package com.team5.aLife.Client;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.google.gson.Gson;

public class EditDeviceActivity extends Activity{
	
	private final String TAG = "EditDeviceActivity";
	
	private Button update, delete;
	
	private EditText deviceName;
	
	Device newDevice;
	
	private Gson gson = new Gson();
	private final String delimiter = "[&]+";
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.editdevice_two);
        
        update = (Button)findViewById(R.id.Update);
        delete = (Button)findViewById(R.id.Delete);
        deviceName = (EditText) findViewById(R.id.DeviceName2);
        
        deviceName.setText(DeviceListActivity.selectedDevice.getDeviceName());
		
		//  Loads LTF on click and stores spinner selection in bundle to pass to new activity
		update.setOnClickListener(updateListener);
		
		//  Loads LTF on click and stores spinner selection in bundle to pass to new activity
		delete.setOnClickListener(deleteListener);
		
	}
	
	 private View.OnClickListener updateListener = new View.OnClickListener() {

	        @Override
	        public void onClick(View v) {
	        	
	        	
	        DeviceListActivity.selectedDevice.setDeviceName(deviceName.getText().toString());	
	        
	        newDevice = DeviceListActivity.selectedDevice;
	        
	        AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
	    	builder.setTitle("Update Device")
	    		   .setMessage("All changes are final, do you want to proceed?")
	    	       .setCancelable(false)
	    	       .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
	    	           public void onClick(DialogInterface dialog, int id) 
	    	           {
	    	        	   
	    	        	   String replyString = socketDispatch.instance().sendReceive(new UpdateDeviceRequest(newDevice));
	    	        	   
	    	        	   String[] tokens = replyString.split(delimiter);
	    	               
	    	               TransactionReply editDeviceReply = gson.fromJson(tokens[1], TransactionReply.class);
	    	               
	    	               if (editDeviceReply.wasTransactionSuccessful())
	    	               {
	    	               	AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
	    	               	builder.setMessage("Transaction Successful")
	    	               	       .setCancelable(false)
	    	               	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
	    	               	           public void onClick(DialogInterface dialog, int id) {
	    	               	        	   //RegisterDeviceActivity.this.finish();
	    	               	        	   //deviceType.setText("");
	    	               	               deviceName.setText("");
	    	               	               //zigbeeAddress.setText("");
	    	               	               //zigbeeStatus.setText("");
	    	               	               //deviceStatus.setText("");
	    	               	           }
	    	               	       });
	    	               	AlertDialog alert = builder.create();
	    	               	alert.show();
	    	               }
	    	               else
	    	               {
	    	               	AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
	    	               	builder.setMessage("Transaction Failed")
	    	               	       .setCancelable(false)
	    	               	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
	    	               	           public void onClick(DialogInterface dialog, int id) {
	    	               	        	   //RegisterDeviceActivity.this.finish();
	    	               	           }
	    	               	       });
	    	               	AlertDialog alert = builder.create();
	    	               	alert.show();
	    	               }
	    	        	   
	    	        	   finish();
	    	           }
	    	       })
	    	       .setNegativeButton("No", new DialogInterface.OnClickListener() {
	    	           public void onClick(DialogInterface dialog, int id) 
	    	           {
	    	                dialog.cancel();
	    	           }
	    	       });
	    	builder.show();
	            
	        }
	    };
	    
	    private View.OnClickListener deleteListener = new View.OnClickListener() {

	        @Override
	        public void onClick(View v) {
	        	
	        	AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
		    	builder.setTitle("Delete Device")
		    		   .setMessage("All changes are final, do you want to proceed?")
		    	       .setCancelable(false)
		    	       .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
		    	           public void onClick(DialogInterface dialog, int id) 
		    	           {
		    	        	   String replyString = socketDispatch.instance().sendReceive(new DeleteDeviceRequest(DeviceListActivity.selectedDevice));
		    	        	   
		    	        	   Log.i(TAG+"onClick", replyString);
		    	        	   
		    	        	   String[] tokens = replyString.split(delimiter);
		    	               
		    	               TransactionReply deleteDeviceReply = gson.fromJson(tokens[1], TransactionReply.class);
		    	               
		    	               if (deleteDeviceReply.wasTransactionSuccessful())
		    	               {
		    	               	AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
		    	               	builder.setMessage("Transaction Successful")
		    	               	       .setCancelable(false)
		    	               	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
		    	               	           public void onClick(DialogInterface dialog, int id) {
		    	               	        	   //RegisterDeviceActivity.this.finish();
		    	               	        	   //deviceType.setText("");
		    	               	               deviceName.setText("");
		    	               	               //zigbeeAddress.setText("");
		    	               	               //zigbeeStatus.setText("");
		    	               	               //deviceStatus.setText("");
		    	               	           }
		    	               	       });
		    	               	AlertDialog alert = builder.create();
		    	               	alert.show();
		    	               }
		    	               else
		    	               {
		    	               	AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
		    	               	builder.setMessage("Transaction Failed")
		    	               	       .setCancelable(false)
		    	               	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
		    	               	           public void onClick(DialogInterface dialog, int id) {
		    	               	        	   //RegisterDeviceActivity.this.finish();
		    	               	           }
		    	               	       });
		    	               	AlertDialog alert = builder.create();
		    	               	alert.show();
		    	               }
			    	   	       
		    	               socketDispatch.instance().sendReceive(new BackgroundServicesOnStartRequest());
		    	        	   finish();
		    	           }
		    	       })
		    	       .setNegativeButton("No", new DialogInterface.OnClickListener() {
		    	           public void onClick(DialogInterface dialog, int id) 
		    	           {
		    	                dialog.cancel();
		    	           }
		    	       });
		    	builder.show();
	            
	        }
	    };

}
